//***********************************************************
//                  E R W R I T E  
//  Save generated grid in ER Mapper output format. 
//                Copyright (c) 1996 by John Coulthard
//
//    This file is part of QuikGrid.
//
//    QuikGrid is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    QuikGrid is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with QuikGrid (File gpl.txt); if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//    or visit their website at http://www.fsf.org/licensing/licenses/gpl.txt .
//
// July 18, 1996 - created.
// October 17/96: Altered to put out the file as
//        Datum: WGS84, Projection: LOCAL and let the
//        Coordinate type default to Meters.
// October 26/96: Try coordinatetype=EN and calculate
//        Registrationblock differently.
// Oct. 12/99:P Change to have calling routine supply filename.
//***********************************************************

#include <windows.h> 
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <strstrea.h>
#include <math.h>
#include <string.h>
#include <commdlg.h>
#include <time.h>
#pragma hdrstop
#include "surfgrid.h"
#include "scatdata.h"
#include "xygrid.h"
#include "utilitys.h"
#include "rc.h"
#include "quikgrid.h"
#include "paintcon.h"
#include "erwrite.h"
#include "assert.h"
#include "loaddata.h"

static OPENFILENAME ofn;

//******************************************************************
//         A b o r t   W r i t e  G r i d   F i l e  
//******************************************************************
static void AbortWriteGridFile( char FileName[] )
{
  ostrstream Buf;

  Buf << "Error writing Grid output to the file "
	   << FileName 
           << ". Disk full? Output terminated. " << ends; 

  char *szBuf = Buf.str();
  NotifyUser( szBuf );
  delete szBuf;

  RestoreCursor();
}
//******************************************************************
//   G e t E R M a p p e r F i l e   N a m e
//*******************************************************************
int GetERMapperFileName( HWND hwnd, char szFile[] )
{
 szFile[0] = '\0';

 memset( &ofn, 0, sizeof(OPENFILENAME) ); // zero structure members

 ofn.lStructSize = sizeof(OPENFILENAME);
 ofn.hwndOwner = hwnd;  // =NULL if no owner required.
 ofn.lpstrFilter = "ER Mapper\0*.ers\0\0";
 ofn.nFilterIndex = 1;
 ofn.lpstrFile = szFile;
 ofn.nMaxFile = 255;        //sizeof(szFile);
 ofn.Flags = OFN_PATHMUSTEXIST|OFN_OVERWRITEPROMPT;
 ofn.lpstrTitle = "Save grid to file in ER Mapper format" ;
 ofn.lpstrDefExt = "ers";
 if( !GetSaveFileName( &ofn ) ) return 0;

  // Make sure the file has the .ers extension.

 if( (ofn.Flags & OFN_EXTENSIONDIFFERENT) || (ofn.nFileExtension==0) )
  {
	 NotifyUser( IDS_NOERMAPPEREXT );
	 return 0;
  }
 return 1;
}
//******************************************************************
//         O u t p u t   E R M A P P E R  F i l e s
//******************************************************************
int OutputERMapperFile( HWND &hwnd, char szFile[] )
{
 ofstream outFile( szFile, ios::out );
 if( !outFile ) 
  { NotifyUser( IDS_NOOUTPUTFILE ); return 0; }

 SetWaitCursor();

 time_t timer;
 struct tm *tblock;

 // gets time of day 
 timer = time(NULL);

 // converts date/time to a structure 
 tblock = gmtime(&timer);

 double dxnormalize, dynormalize;
 LoadNormalization( dxnormalize, dynormalize ); 

 int nx = Zgrid.xsize();
 int ny = Zgrid.ysize();

 outFile 
 << "# Generated by QuikGrid on (GMT) " << asctime(tblock)
 << " DatasetHeader Begin "                  << endl
 << "   Version         = \"5.2\" "          << endl
 << "   DataSetType	= ERStorage "        << endl
 << "   DataType	= Raster "           << endl
 << "   ByteOrder	= LSBFirst "         << endl
 << "   CoordinateSpace Begin "              << endl
 << "           Datum           = \"WGS84\" "<< endl
 << "           Projection      = \"LOCAL\" "<< endl
 << "           CoordinateType  = EN "       << endl
 << "           Rotation        = 0:0:0.0 "  << endl
 << "   CoordinateSpace End "                << endl
 << "   RasterInfo Begin "                   << endl ;

 outFile 
 << "           CellType        = IEEE4ByteReal " << endl
 << "           NullCellValue   = -99999 "        << endl
 << "           CellInfo Begin "                  << endl
 << "              Xdimension = " << Zgrid.x(1)-Zgrid.x(0) << endl
 << "              Ydimension = " << Zgrid.y(1)-Zgrid.y(0) << endl
 << "           CellInfo End   "                  << endl 
 << "           NrOfLines        = " << ny        << endl
 << "           NrOfCellsPerLine = " << nx        << endl
 << "           RegistrationCoord Begin "         << endl
 << "               Eastings  = "
           << Zgrid.x(0)+dxnormalize-.5*(Zgrid.x(1)-Zgrid.x(0))  << endl
 << "               Northings = "
	   << Zgrid.y(ny-1)+dynormalize+.5*(Zgrid.y(1)-Zgrid.y(0))  << endl
 << "           RegistrationCoord End "           << endl
 //<< "           RegistrationCellX = " << Zgrid.x(0)+dxnormalize << endl
 //<< "           RegistrationCellY = " << Zgrid.y(ny-1)+dynormalize << endl
 << "           NrOfBands = 1  "            << endl
 << "    RasterInfo End   "                        << endl
 << " DatasetHeader End   "                       << endl ;

 outFile.close();

 // Now remove the ".ers" file extension
 // and write out the actual grid in binary.

 //szFile[ofn.nFileExtension-1] = '\0';
 szFile[strlen(szFile)-4] = '\0'; 
 ofstream binFile( szFile, ios::binary );
 if( !binFile ) 
  { NotifyUser( IDS_NOOUTPUTFILE ); return 0; }

 float zadjust = ScatterData.zAdjust();
 float zValue;
 unsigned char czValue[4];

 for( int j = ny-1; j >= 0 ; j-- )
   { for( int i = 0; i < nx; i++ )
     { 
	    zValue = Zgrid.z(i,j) ;
       if( zValue > 0 ) zValue = zValue-zadjust;
	    memcpy( czValue,  &zValue, 4 );
	    binFile.write( czValue, 4 ) ;
                
       if( outFile.fail() ){ AbortWriteGridFile( szFile );
			       outFile.close();
			       return 0; }
     }
  }

 binFile.close();

 RestoreCursor();

 return 1;

}